import { Component, Input } from "@angular/core";
import { Model } from "../model/repository.model";
import { Product } from "../model/product.model";
import { DiscountService } from "../common/discount.service";
import { LogService } from "../common/log.service";

@Component({
    selector: "paProductTable",
    templateUrl: "productTable.component.html",
    providers:[LogService]
})
export class ProductTableComponent {   
    constructor(private dataModel: Model) {}

    getProduct(key: number): Product {
        return this.dataModel.getProduct(key);
    }

    getProducts(): Product[] {
        return this.dataModel.getProducts();
    }

    deleteProduct(key: number) {
        this.dataModel.deleteProduct(key);
    }

    taxRate: number = 0;
    dateObject: Date = new Date(2020, 1, 20);
    dateString: string = "2020-02-20T00:00:00.000Z";
    dateNumber: number = 1582156800000;

    selectMap = {
        "Sporty wodne": "nie przemoknąć",
        "Piłka nożna": "strzelać bramki",
        "other": "dobrze się bawić"
    }

    numberMap = {
        "=1": "jeden produkt",
        "=2": "dwa produkty",
        "other": "# produktów"
    }
}
